# GURPS character template macros.

# List of items to add to character template.

$$macro items(value)
{{
$$hidemacro()
	opt
		begin text "Items" "$(value)" noprint end
		end
}}

# Add an option.

$$macro opt(name, value)
{{
$$hidemacro()
	$$ifdef(value) begin text "$(name)" "$(value)" noprint end $$endif
}}

# List of required items. 
# list: name of list to add to.
# items: comma-separated list of items.
# Items can be in these forms:
#	Blur
#		Just adds item at default level
#	Blur=13
#		Sets item to a value.
#	?Blur=14
#		Let the user edit this before adding.
#	Enemy[Enemy (Law Enforcement)]
#		Renames item to value in the []
#	Poverty{Level=Struggling}
#		Adds item and sets options on it. Separate multiple options with "/".
#	*Combat/Weapon
#		Choose items from category.
#	2:*Combat/Weapon
#		Choose 2 points of skills from specified category
#	#2:*Combat/Weapon
#		Choose two skills from category
#	ST+1
#		Attribute increase/decrease (ST, DX, IQ, HT).

$$macro req(list, items)
{{
$$macrodesc("Required items for template")
$$argdesc(list, "List to add to. Conditional may be specified before list (e.g., ?{TL<5}Advantages)")
$$argdesc(items, "Items to add, comma-separated")

	$$ifnull(items)
		$$error(Missing item list in req macro)
	$$endif
	opt
		begin text "Items" "$(list)~$(items)" noprint end
		end
}}


# Specify a list of items to choose from.
# list: list name
# points: number of points to spend, or if "#2" to specify 2 items.
# items: List of items, as above, with the following extra syntax:
#	!Duty
#		Always add this item
# To allow multiple instances of the same item in the list, include the
# value ?multiple as the first entry in items. To specify the title
# for the dialog box, include ?title{Dialog Box Title} in the item list.
# To suppress items already chosen from the list of choices, specify
# ?suppdups[=level] in the item list.

$$macro choose(list, points, items)
{{
$$macrodesc("List of items to choose from for template")
$$argdesc(list, "List to add to. Conditional may be specified before list (e.g., ?{TL<5}Advantages)")
$$argdesc(points, "Number of points to spend, or number items (#2 means choose two items)")
$$argdesc(items, "Items to choose from, comma-separated")

	$$if(strindex(points, "/[^-#0-9]/")>0)
		$$error(Points for choose macro must be a number)
	$$endif
	opt
		begin text "Items" "$(list)~$(points):$(items)" noprint end
		end
}}


# Choose from a list of specializations.
# cat = The "category" of the specialization. This is some name that gives a general
# idea of what the specialization. "Specialization" is usually enough. This value is
# repeated for all the specialization instances that occur.
# type: The name to display for this instance. The user will pick this name from
# a listbox.
# list: the list to add to.
# items: the list of items (as above) to choose from.

$$macro spec(cat, type, list, items)
{{
$$macrodesc("Choose from a list of specializations")
$$argdesc(name, "The \"category\" of the specialiation")
$$argdesc(type, "The name to display for this instance")
$$argdesc(list, "List to add to")
$$argdesc(items, "Items to choose from")
	opt
		begin text "Items" "$(cat):$(type)|$(list)~$(items)" 
			noprint end
		end
}}


$$macro append(exp, items)
{{
$$macrodesc("Append to previous item list")
$$argdesc(exp, "If one argument, just append this argument")
$$argdesc(items, "If two arguments, the first is an expression, which if true appends the list of items in the second argument to the previous list")
	opt
		begin text Items "&$$ifdef(items)?$(exp):$(items)$$else$(exp)$$endif" noprint end
		end
}}


$$macro select(arg1, arg2, arg3)
{{
$$macrodesc("Select a value into a script variable.")
$$argdesc(arg1, "Two arguments: the name of the selection. Three arguments: an expression, which if true causes the selection to be presented to the user")
$$argdesc(arg2, "Two arguments: the comma-separated list of the values to select from. Three arguments: the name of the selection")
$$argdesc(arg3, "Three arguments: the comma-separated list of the values to select from")
	opt
		$$ifdef(arg3)
			begin Text Select	"{$(arg1)}$(arg2):$(arg3)" noprint end
		$$else
			begin Text Select	"$(arg1):$(arg2)" noprint end
		$$endif
		end
}}


$$macro template(type, name, pts, st, dx, iq, ht, assign, notes, mintl, req, chartype, begPts, maxDisadv, datasheets)
{{
$$macrodesc("The template macro. It should be followed by a number of other macros that indicate the items to add.")
$$argdesc(type, "Type of template: Wizard, Warrior, Professional, etc.")
$$argdesc(name, "Name of the template.")
$$argdesc(pts, "Number of character points in the template")
$$argdesc(st, "Minimum ST required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(dx, "Minimum DX required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(iq, "Minimum IQ required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(ht, "Minimum HT required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(assign, "Semicolon-delimited list of assignments to dialog field values (optional). For example, \"Information.Age=16;Configuration.disadvlim=75\". Use with care.")
$$argdesc(notes, "Notes for the template")
$$argdesc(mintl, "Minimum TL required for template")
$$argdesc(req: req, "Requirements")
$$argdesc(chartype, "Character type")
$$argdesc(begPts, "Beginning points")
$$argdesc(maxDisadv, "Maximum points in disadvantages")
$$argdesc(datasheets, "Additional data sheets that must be loaded (separated by commas)")

	$$if(strindex(ht, "/[0-9]/") <= 0)
		$$error(Missing argument in template macro)
	$$endif
	$$item($(name))
	cat "*Template;*$(type)"
	editdlg 2
	sformat %0ln
	format %0ln
	$$scan(st, "^([0-9]+)(-?)$", xst, stopt)
	$$scan(dx, "^([0-9]+)(-?)$", xdx, dxopt)
	$$scan(iq, "^([0-9]+)(-?)$", xiq, iqopt)
	$$scan(ht, "^([0-9]+)(-?)$", xht, htopt)
	prereq "$$ifnull(stopt)Main:ST>=$(xst)$$endif$$ifnull(dxopt);Main:DX>=$(xdx)$$endif$$ifnull(iqopt);Main:IQ>=$(xiq)$$endif$$ifnull(htopt);Main:HT>=$(xht)$$endif$$ifdef(req);$(req)$$endif"
	autoitems ""
	$$ifdef(notes) notes "$(notes)" $$endif
	deleteauto
	opt
		$$opt(Points, $(pts))
		$$opt(Beginning Points, $(begPts))
		$$opt(Maximum Disadvantages, $(maxDisadv))
		$$opt(Character Type, $(chartype))
		$$opt(ST, $(xst))
		$$opt(DX, $(xdx))
		$$opt(IQ, $(xiq))
		$$opt(HT, $(xht))
		$$opt(Minimum TL, $(mintl))
		$$opt(Assignments, $(assign))
		$$opt(Data Sheets, $(datasheets))
		end
}}


# Wizard template.

$$macro wiz(name, pts, st, dx, iq, ht, assign, notes, mintl, req, chartype, begPts, maxDisadv, datasheets)
{{
$$macrodesc("Wizard template macro")
$$argdesc(name, "Name of wizard template")
$$argdesc(pts, "Number of character points in the template")
$$argdesc(st, "Minimum ST required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(dx, "Minimum DX required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(iq, "Minimum IQ required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(ht, "Minimum HT required for the template. If followed by \"-\" it is only a suggestion.")
$$argdesc(assign, "Any assignments. Currently unused.")
$$argdesc(notes, "Notes for the template")
$$argdesc(mintl, "Minimum TL required for template")
$$argdesc(req: req, "Requirements")
$$argdesc(chartype, "Character type")
$$argdesc(begPts, "Beginning points")
$$argdesc(maxDisadv, "Maximum points in disadvantages")
$$argdesc(datasheets, "Additional data sheets that must be loaded (separated by commas)")

	$$ifdef(datasheets)
		$$template(Wizard, $(name), $(pts), $(st), $(dx), $(iq), $(ht), $(assign), $(notes), , , , , , "GURPSMagic.cds,GURPSGrimoire.cds,$(datasheets)")
	$$else
		$$template(Wizard, $(name), $(pts), $(st), $(dx), $(iq), $(ht), $(assign), $(notes), , , , , , "GURPSMagic.cds,GURPSGrimoire.cds")
	$$endif
}}

# Shortcut macros: skills, advs, and disadvs. If one argument, items are required.
# If two arguments, the first is the number of points (or number of items) and the
# second is the list of items.

$$macro skills(arg1, arg2)
{{
$$macrodesc("Template skills macro")
$$argdesc(arg1, "If only argument, the required items. If first argument, points to spend or number of skills.")
$$argdesc(arg2, "If present, comma-delimited list of skills")
	$$ifdef(arg2)
		$$choose(Skills, $(arg1), $(arg2))
	$$else	
		$$req(Skills, $(arg1))
	$$endif
}}

$$macro advs(arg1, arg2)
{{
$$macrodesc("Template advantages macro")
$$argdesc(arg1, "If only argument, the required items. If first argument, points to spend or number of advantages.")
$$argdesc(arg2, "If present, comma-delimited list of advantages")
	$$ifdef(arg2)
		$$choose(Advantages, $(arg1), $(arg2))
	$$else	
		$$req(Advantages, $(arg1))
	$$endif
}}

$$macro disadvs(arg1, arg2)
{{
$$macrodesc("Template disadvantages macro")
$$argdesc(arg1, "If only argument, the required items. If first argument, points to spend or number of disadvantages.")
$$argdesc(arg2, "If present, comma-delimited list of disadvantages")
	$$ifdef(arg2)
		$$choose(Disadvantages, $(arg1), $(arg2))
	$$else	
		$$req(Disadvantages, $(arg1))
	$$endif
}}



$$macro itemList(name, items)
{{
$$macrodesc("Macro for list of common items for template builder lists")
$$argdesc(name, "Name of item list")
$$argdesc(items, "List of items (comma-delimited)")

	$$item($(name))
	cat "Item List"
	format %0ln sformat %0ln
	editdlg 5
	opt
		begin text Items "$(items)" keepold noprint end
		end
}}

